
public class ArtRocketDone {

	public static final int SIZE = 3;

	public static void main(String[] args) {
		cone();
		divider();
		linesPointUp();
		linesPointDown();
		divider();
		linesPointDown();
		linesPointUp();
		divider();
		cone();
	}

	// print top of rocket
	private static void cone() {
		// loop one time for each line
		for (int line = 1; line <= ((SIZE * 2) - 1); line++) {
			for (int character = 1; character <= ((SIZE * 2) - line); character++) {
				System.out.print(" ");
			}
			for (int character = 1; character <= line; character++) {
				System.out.print("/");
			}
			System.out.print("**");
			for (int character = 1; character <= line; character++) {
				System.out.print("\\");
			}
			System.out.println();
		}

	}

	private static void linesPointUp() {
		// loop once per line
		for (int line = 1; line <= SIZE; line++) {
			// print edge
			System.out.print("|");
			// print side dots
			for (int character = 1; character <= SIZE - line; character++) {
				System.out.print(".");
			}
			// print forward/backward slashes
			for (int character = 1; character <= line; character++) {
				System.out.print("/\\");
			}

			// print middle dots
			for (int character = 1; character <= ((SIZE - line) * 2); character++) {
				System.out.print(".");
			}
			// print forward slashes
			for (int character = 1; character <= line; character++) {
				System.out.print("/\\");
			}
			// print side dots
			for (int character = 1; character <= SIZE - line; character++) {
				System.out.print(".");
			}
			// print edge
			System.out.print("|");
			// print newline at end of line
			System.out.println();
		}
	}

	private static void linesPointDown() {
		// loop once per line
		for (int line = 1; line <= SIZE; line++) {
			// print edge
			System.out.print("|");
			// print side dots
			for (int character = 1; character <= line - 1; character++) {
				System.out.print(".");
			}
			// print slash pairs
			for (int character = 1; character <= (SIZE - line + 1); character++) {
				System.out.print("\\/");
			}
			// print middle dots
			for (int character = 1; character <= ((line - 1) * 2); character++) {
				System.out.print(".");
			}
			// print slash pairs
			for (int character = 1; character <= (SIZE - line + 1); character++) {
				System.out.print("\\/");
			}
			// print side dots
			for (int character = 1; character <= (line - 1); character++) {
				System.out.print(".");
			}
			// print edge
			System.out.print("|");
			// print newline at end of line
			System.out.println();
		}
	}

	// print dividing line
	private static void divider() {
		System.out.print("+");
		for (int character = 1; character <= SIZE * 2; character++) {
			System.out.print("=*");
		}
		System.out.println("+");
	}

}
